/*
	File:		UDialogUtils.h

	Contains:	Dialog item utility routines.

	Version:	Appearance 1.0 SDK

	Copyright:	 1997 by Apple Computer, Inc., all rights reserved.

	File Ownership:

		DRI:				Edward Voas

		Other Contact:		7 of 9, Borg Collective

		Technology:			OS Technologies Group

	Writers:

		(edv)	Ed Voas

	Change History (most recent first):

		 <1>	 9/11/97	edv		First checked in.
*/

#ifndef _UDIALOGUTILS_
#define _UDIALOGUTILS_

#include <Appearance.h>
#include <Controls.h>
#include <Dialogs.h>

class UDialogUtils
{
	public:
		static	Handle		GetDialogItemHandle( DialogPtr theDialog, short item );
		static	void		SetDialogItemHandle( DialogPtr theDialog, short item, Handle handle );
		static	void		GetDialogItemRect( DialogPtr theDialog, short item, Rect& rect );
		static	void		SetDialogItemRect( DialogPtr theDialog, short item, const Rect& rect );
		static	void		SetDialogItemValue( DialogPtr dialog, short item, short value );
		static	SInt16		GetDialogItemValue( DialogPtr dialog, short item );
		static	void		SetDialogItemText( DialogPtr dialog, short item, StringPtr text );
		static	void		GetDialogItemText( DialogPtr dialog, short item, StringPtr text );
		static	void		FlashDialogItem( DialogPtr theDialog, short item );
		static	void		ToggleCheckBox( DialogPtr theDialog, short item );
		static	void		EnableDialogItem( DialogPtr dialog, short item, Boolean enableIt );
		static	void		SetFontStyle( DialogPtr dialog, short item, ControlFontStyleRec& style );
};

#endif // _UDIALOGUTILS_
